/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.rs6k.indication.server;

import com.ibm.hsc.cim.provider.rs6k.indication.client.HSCSocket;
import com.ibm.hsc.cim.provider.rs6k.indication.client.HSCSubscription;
import com.ibm.hsc.cim.provider.rs6k.indication.server.HSCObjectSender;
import com.ibm.hsc.common.util.HSCLogUtils;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Vector;

public class HSCListener {
    private HSCSocket mSocket;
    private boolean mClosed;
    private boolean mNeedClose;
    private HSCObjectSender mObjSender = null;
    private Vector mQueuedObjs = new Vector();
    private String mAuthKey = null;
    private long mConnCreateTime;
    private Vector mEvents;
    private String mClientInfo = null;
    private int mPort;

    public HSCListener(HSCSocket hSCSocket, int n) {
        this.mSocket = hSCSocket;
        this.mNeedClose = false;
        this.mClosed = false;
        this.mEvents = new Vector();
        this.mPort = n;
        this.mConnCreateTime = System.currentTimeMillis();
    }

    int getPort() {
        return this.mPort;
    }

    public String getAuthKey() {
        return this.mAuthKey;
    }

    public void printStatus() {
        System.out.println("mClosed: " + this.mClosed);
        System.out.println("mNeedClose: " + this.mNeedClose);
        System.out.println("mConnCreationTime: " + new Timestamp(this.mConnCreateTime));
        System.out.println("mAuthKey: " + this.mAuthKey);
        System.out.println("mEvents: " + this.mEvents);
        System.out.println("mQueuedObjs.size(): " + this.mQueuedObjs.size());
        if (this.mObjSender == null) {
            System.out.println("mObjSender is null.");
        } else {
            System.out.println("mLastWriteTime: " + new Timestamp(this.mObjSender.getLastWriteTime()));
        }
    }

    public String subscribe(HSCSubscription hSCSubscription) {
        String string = hSCSubscription.getEventKey();
        if (this.mAuthKey == null) {
            this.mAuthKey = hSCSubscription.getAuthKey();
        } else {
            if (!this.mAuthKey.equals(hSCSubscription.getAuthKey())) {
                return null;
            }
            if (this.mEvents.indexOf(string) != -1) {
                return null;
            }
        }
        this.mEvents.addElement(string);
        return string;
    }

    public String unsubscribe(HSCSubscription hSCSubscription) {
        String string = hSCSubscription.getEventKey();
        if (this.mAuthKey == null) {
            return null;
        }
        if (!this.mAuthKey.equals(hSCSubscription.getAuthKey())) {
            return null;
        }
        if (this.mEvents.indexOf(string) == -1) {
            return null;
        }
        this.mEvents.removeElement(string);
        return string;
    }

    public Vector getEventKeys() {
        return this.mEvents;
    }

    public HSCSubscription readSubscription() throws IOException {
        Object object = this.mSocket.readObject();
        HSCSubscription hSCSubscription = null;
        hSCSubscription = object instanceof com.ibm.hsc.indication.client.HSCSubscription ? this.getRegattaSub((com.ibm.hsc.indication.client.HSCSubscription)object) : (HSCSubscription)object;
        if (hSCSubscription != null) {
            System.out.println("is subscribe " + hSCSubscription.isSubscription());
        }
        return hSCSubscription;
    }

    public void deliverEvent(Object object) {
        this.sendOutObject(object);
    }

    private synchronized void sendOutObject(Object object) {
        if (this.mNeedClose) {
            return;
        }
        this.accessQueuedObjects(object, false);
    }

    public synchronized Object accessQueuedObjects(Object object, boolean bl) {
        if (bl) {
            return this.mObjSender;
        }
        if (object != null) {
            if (this.mObjSender == null) {
                this.mObjSender = new HSCObjectSender(this.mSocket, object, this);
                this.mObjSender.start();
            } else {
                this.mQueuedObjs.addElement(object);
            }
            return null;
        }
        if (this.mQueuedObjs.size() == 0) {
            this.mObjSender = null;
            return null;
        }
        return this.mQueuedObjs.remove(0);
    }

    public boolean handleTimeOut(long l) {
        HSCObjectSender hSCObjectSender = (HSCObjectSender)this.accessQueuedObjects(null, true);
        if (hSCObjectSender == null) {
            return false;
        }
        long l2 = hSCObjectSender.getLastWriteTime();
        if (l2 == 0L) {
            return false;
        }
        if (l - l2 > 10000L) {
            System.out.println("Timeout after 10 seconds\n\n\n\n");
            this.close();
            System.out.println("after close");
            hSCObjectSender.interrupt();
            System.out.println("aft interrupt");
            this.mNeedClose = true;
            return true;
        }
        return false;
    }

    public void sendSubStatus(HSCSubscription hSCSubscription) throws IOException {
        this.sendOutObject(hSCSubscription);
    }

    public void close() {
        if (this.mClosed) {
            return;
        }
        try {
            this.mSocket.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            HSCLogUtils.serverLog(exception, HSCLogUtils._IndicationClassLogInfo);
        }
        this.mQueuedObjs = null;
        this.mObjSender = null;
        this.mClosed = true;
        this.mNeedClose = true;
    }

    public boolean isNeedClose() {
        return this.mNeedClose;
    }

    public void setNeedClose() {
        System.out.println("set need close time out after 4 second\n\n\n\n");
        this.mNeedClose = true;
    }

    private HSCSubscription getRegattaSub(com.ibm.hsc.indication.client.HSCSubscription hSCSubscription) {
        HSCSubscription hSCSubscription2 = new HSCSubscription(hSCSubscription.getEventType(), hSCSubscription.getObjectType(), hSCSubscription.isSubscription(), null, null, null);
        hSCSubscription2.setAuthKey(hSCSubscription.getAuthKey());
        return hSCSubscription2;
    }
}

